/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stonechest.client;

import ftblag.stonechest.blocks.EnumStoneChest;
import ftblag.stonechest.tileentities.TileEntityStoneChest;
import java.util.Locale;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityStoneChestRenderer
extends ChestRenderer<TileEntityStoneChest> {
    public static Material[] single = new Material[EnumStoneChest.VALUES.length];
    public static Material[] left = new Material[EnumStoneChest.VALUES.length];
    public static Material[] right = new Material[EnumStoneChest.VALUES.length];

    public TileEntityStoneChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(TileEntityStoneChest blockEntity, ChestType chestType) {
        return TileEntityStoneChestRenderer.getChestMaterial(blockEntity, chestType);
    }

    private static Material getChestMaterial(String path) {
        return new Material(Sheets.f_110740_, new ResourceLocation("stonechest", "entity/chest/" + path));
    }

    private static Material getChestMaterial(TileEntityStoneChest tile, ChestType type) {
        switch (type) {
            case LEFT: {
                return left[tile.getChestType().ordinal()];
            }
            case RIGHT: {
                return right[tile.getChestType().ordinal()];
            }
        }
        return single[tile.getChestType().ordinal()];
    }

    static {
        for (EnumStoneChest type : EnumStoneChest.VALUES) {
            TileEntityStoneChestRenderer.single[type.ordinal()] = TileEntityStoneChestRenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH));
            TileEntityStoneChestRenderer.left[type.ordinal()] = TileEntityStoneChestRenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH) + "_left");
            TileEntityStoneChestRenderer.right[type.ordinal()] = TileEntityStoneChestRenderer.getChestMaterial(type.name().toLowerCase(Locale.ENGLISH) + "_right");
        }
    }
}

